<?php
require_once '../config/db.php';
checkAuth();

$user_id = $_SESSION['user']['id'];
$report_id = isset($_GET['report_id']) ? (int)$_GET['report_id'] : 0;

$check = mysqli_query($conn, "SELECT * FROM daily_reports WHERE id = $report_id AND user_id = $user_id");
if (mysqli_num_rows($check) == 0) {
    die("Report not found or access denied.");
}
$report = mysqli_fetch_assoc($check);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $type = $_POST['task_type'];
    $client = mysqli_real_escape_string($conn, $_POST['client_name']);
    $tid = mysqli_real_escape_string($conn, $_POST['ticket_id']);
    $desc = mysqli_real_escape_string($conn, $_POST['description']);
    $time = mysqli_real_escape_string($conn, $_POST['time_spent']);

    $sql = "INSERT INTO tasks (daily_report_id, task_type, client_name, ticket_id, description, time_spent) 
            VALUES ($report_id, '$type', '$client', '$tid', '$desc', '$time')";
    mysqli_query($conn, $sql);
    header("Location: add_task.php?report_id=$report_id");
    exit;
}

$stats = [];
$res = mysqli_query($conn, "SELECT * FROM tasks WHERE daily_report_id = $report_id ORDER BY created_at DESC");
while ($row = mysqli_fetch_assoc($res)) {
    $stats[$row['task_type']][] = $row;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Add Task</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-4">
    <a href="dashboard.php?date=<?= $report['report_date'] ?>" class="btn btn-secondary mb-3">&laquo; Back to Dashboard</a>
    <div class="row">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">Add Entry</div>
                <div class="card-body">
                    <form method="POST">
                        <div class="mb-3">
                            <label>Type</label>
                            <select name="task_type" class="form-select">
                                <option value="ticket">Ticket</option>
                                <option value="whatsapp">WhatsApp</option>
                                <option value="chat">Chat</option>
                                <option value="alert">Alert</option>
                                <option value="task">Other Task</option>
                            </select>
                        </div>
                        <div class="mb-3"><label>Client Name</label><input type="text" name="client_name" class="form-control" required></div>
                        <div class="mb-3"><label>Ticket ID (Optional)</label><input type="text" name="ticket_id" class="form-control"></div>
                        <div class="mb-3"><label>Description</label><textarea name="description" class="form-control" rows="3" required></textarea></div>
                        <div class="mb-3"><label>Time Spent (e.g. 30m, 1h)</label><input type="text" name="time_spent" class="form-control"></div>
                        <button type="submit" class="btn btn-success w-100">Add Entry</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Current Shift Report (Preview)</div>
                <div class="card-body" style="font-size: 0.9em; max-height:600px; overflow-y:auto;">
                    <?php 
                    $groups = ['ticket', 'whatsapp', 'chat'];
                    foreach($groups as $gType): 
                        if(!empty($stats[$gType])):
                            $clients = [];
                            foreach($stats[$gType] as $item) $clients[$item['client_name']][] = $item;
                    ?>
                    <h6><?= ucfirst($gType) ?>s (Total: <?= count($stats[$gType]) ?>)</h6>
                    <ul class="list-unstyled ms-3">
                        <?php foreach($clients as $cName => $items): ?>
                        <li><strong><?= $cName ?> (<?= count($items) ?>):</strong>
                            <ul>
                                <?php foreach($items as $i): ?>
                                <li><?= $i['ticket_id'] ? $i['ticket_id'].' - ' : '' ?><?= $i['description'] ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                    <hr>
                    <?php endif; endforeach; ?>

                    <?php 
                    $simple = ['alert', 'task'];
                    foreach($simple as $sType): 
                        if(!empty($stats[$sType])):
                    ?>
                    <h6><?= ucfirst($sType) ?>s (<?= count($stats[$sType]) ?>)</h6>
                    <ul>
                        <?php foreach($stats[$sType] as $i): ?>
                        <li><?= $i['client_name'] ?>: <?= $i['description'] ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <hr>
                    <?php endif; endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
