<?php
require_once '../config/db.php';
checkAuth();
checkRole('employee');

$user_id = $_SESSION['user']['id'];
$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

if (isset($_POST['update_shift'])) {
    $new_shift = $_POST['shift'];
    $report_id = $_POST['report_id'];
    mysqli_query($conn, "UPDATE daily_reports SET shift='$new_shift' WHERE id=$report_id AND user_id=$user_id");
    header("Location: dashboard.php?date=$date");
    exit;
}

if (isset($_POST['update_hours'])) {
    $hours = mysqli_real_escape_string($conn, $_POST['total_hours']);
    $report_id = $_POST['report_id'];
    mysqli_query($conn, "UPDATE daily_reports SET total_worked_hours='$hours' WHERE id=$report_id AND user_id=$user_id");
    header("Location: dashboard.php?date=$date");
    exit;
}

if (isset($_POST['calculate_hours'])) {
    $report_id = $_POST['report_id'];
    $t_res = mysqli_query($conn, "SELECT time_spent FROM tasks WHERE daily_report_id = $report_id");
    $total_seconds = 0;
    while($row = mysqli_fetch_assoc($t_res)) {
        $total_seconds += parseTimeToSeconds($row['time_spent']);
    }
    $final_time = secondsToTime($total_seconds);
    mysqli_query($conn, "UPDATE daily_reports SET total_worked_hours='$final_time' WHERE id=$report_id AND user_id=$user_id");
    header("Location: dashboard.php?date=$date");
    exit;
}

$query = "SELECT * FROM daily_reports WHERE user_id = $user_id AND report_date = '$date'";
$result = mysqli_query($conn, $query);
$report = mysqli_fetch_assoc($result);

if (!$report && $date == date('Y-m-d')) {
    header("Location: select_shift.php");
    exit;
}

$tasks = [];
if ($report) {
    $t_sql = "SELECT * FROM tasks WHERE daily_report_id = " . $report['id'] . " ORDER BY created_at DESC";
    $t_res = mysqli_query($conn, $t_sql);
    while ($row = mysqli_fetch_assoc($t_res)) {
        $tasks[$row['task_type']][] = $row;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">DailyShiftReport</a>
    <div class="navbar-nav ms-auto">
      <a class="nav-link active" href="dashboard.php">Dashboard</a>
      <a class="nav-link" href="reports.php">History</a>
      <a class="nav-link text-danger" href="logout.php">Logout (<?= $_SESSION['user']['name'] ?>)</a>
    </div>
  </div>
</nav>

<div class="container">
    <div class="row mb-3 align-items-center">
        <div class="col-md-4"><h4>Dashboard: <?= $date ?></h4></div>
        <div class="col-md-4">
            <form action="" method="GET" class="d-flex">
                <input type="date" name="date" class="form-control me-2" value="<?= $date ?>">
                <button class="btn btn-secondary">Go</button>
            </form>
        </div>
        <div class="col-md-4 text-end">
            <?php if($report): ?>
                <a href="add_task.php?report_id=<?= $report['id'] ?>" class="btn btn-success">+ Add Entry</a>
                <a href="export_tasks.php?date=<?= $date ?>" target="_blank" class="btn btn-outline-primary">Export CSV</a>
            <?php endif; ?>
        </div>
    </div>

    <?php if (!$report): ?>
        <div class="alert alert-warning">No report found for this date.</div>
    <?php else: ?>

    <div class="card mb-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <strong>Team:</strong> <?= $_SESSION['user']['team'] ?><br>
                    <strong>Shift:</strong> 
                    <form method="POST" class="d-inline-flex">
                        <input type="hidden" name="report_id" value="<?= $report['id'] ?>">
                        <select name="shift" class="form-select form-select-sm" onchange="this.form.submit()">
                            <?php foreach(['morning','noon','night','general'] as $s): ?>
                                <option name="update_shift" value="<?=$s?>" <?= $report['shift'] == $s ? 'selected':'' ?>><?= ucfirst($s) ?></option>
                            <?php endforeach; ?>
                            <input type="hidden" name="update_shift" value="1">
                        </select>
                    </form>
                </div>
                <div class="col-md-8">
                    <form method="POST" class="row g-2 align-items-center justify-content-end">
                        <div class="col-auto"><label>Total Hours:</label></div>
                        <div class="col-auto">
                            <input type="text" name="total_hours" value="<?= $report['total_worked_hours'] ?>" class="form-control form-control-sm">
                        </div>
                        <input type="hidden" name="report_id" value="<?= $report['id'] ?>">
                        <div class="col-auto">
                            <button type="submit" name="update_hours" class="btn btn-sm btn-primary">Save</button>
                            <button type="submit" name="calculate_hours" class="btn btn-sm btn-warning">Auto Calc</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php 
    $sections = ['ticket' => 'Tickets','whatsapp' => 'WhatsApp Tasks','chat' => 'Chats','alert' => 'Alerts','task' => 'Other Tasks'];
    foreach($sections as $type => $title): 
        if(isset($tasks[$type])):
    ?>
    <div class="card mb-3">
        <div class="card-header bg-secondary text-white"><?= $title ?></div>
        <div class="card-body p-0">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Client</th>
                        <?php if($type == 'ticket') echo '<th>Ticket ID</th>'; ?>
                        <th>Description</th>
                        <th>Duration</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($tasks[$type] as $task): ?>
                    <tr>
                        <td><?= date('H:i', strtotime($task['created_at'])) ?></td>
                        <td><?= htmlspecialchars($task['client_name']) ?></td>
                        <?php if($type == 'ticket') echo '<td>'.htmlspecialchars($task['ticket_id']).'</td>'; ?>
                        <td><?= nl2br(htmlspecialchars($task['description'])) ?></td>
                        <td><?= htmlspecialchars($task['time_spent']) ?></td>
                        <td><a href="edit_task.php?id=<?= $task['id'] ?>" class="btn btn-sm btn-outline-dark">Edit</a></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; endforeach; ?>

    <?php if(empty($tasks)): ?>
        <p class="text-center text-muted">No entries added yet.</p>
    <?php endif; ?>

    <?php endif; ?>
</div>
</body>
</html>
