<?php
require_once '../config/db.php';
checkAuth();
$user_id = $_SESSION['user']['id'];
$task_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$sql = "SELECT t.*, r.report_date FROM tasks t 
        JOIN daily_reports r ON t.daily_report_id = r.id 
        WHERE t.id = $task_id AND r.user_id = $user_id";
$res = mysqli_query($conn, $sql);
$task = mysqli_fetch_assoc($res);

if (!$task) die("Task not found.");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $type = $_POST['task_type'];
    $client = mysqli_real_escape_string($conn, $_POST['client_name']);
    $tid = mysqli_real_escape_string($conn, $_POST['ticket_id']);
    $desc = mysqli_real_escape_string($conn, $_POST['description']);
    $time = mysqli_real_escape_string($conn, $_POST['time_spent']);
    $upd = "UPDATE tasks SET task_type='$type', client_name='$client', ticket_id='$tid', description='$desc', time_spent='$time' WHERE id=$task_id";
    mysqli_query($conn, $upd);
    header("Location: dashboard.php?date=" . $task['report_date']);
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Task</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5" style="max-width: 600px;">
    <div class="card">
        <div class="card-header">Edit Task</div>
        <div class="card-body">
            <form method="POST">
                <div class="mb-3">
                    <label>Type</label>
                    <select name="task_type" class="form-select">
                        <?php foreach(['ticket','whatsapp','chat','alert','task'] as $opt): ?>
                        <option value="<?=$opt?>" <?= $task['task_type']==$opt?'selected':'' ?>><?= ucfirst($opt) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3"><label>Client</label><input type="text" name="client_name" value="<?= htmlspecialchars($task['client_name']) ?>" class="form-control" required></div>
                <div class="mb-3"><label>Ticket ID</label><input type="text" name="ticket_id" value="<?= htmlspecialchars($task['ticket_id']) ?>" class="form-control"></div>
                <div class="mb-3"><label>Description</label><textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($task['description']) ?></textarea></div>
                <div class="mb-3"><label>Time Spent</label><input type="text" name="time_spent" value="<?= htmlspecialchars($task['time_spent']) ?>" class="form-control"></div>
                <button type="submit" class="btn btn-primary">Update</button>
                <a href="dashboard.php?date=<?= $task['report_date'] ?>" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
</body>
</html>
