<?php
require_once '../config/db.php';
checkAuth();
$user_id = $_SESSION['user']['id'];

$sql = "SELECT r.*, 
        COUNT(CASE WHEN t.task_type='ticket' THEN 1 END) as tickets,
        COUNT(CASE WHEN t.task_type='whatsapp' THEN 1 END) as whatsapps,
        COUNT(CASE WHEN t.task_type='chat' THEN 1 END) as chats,
        COUNT(CASE WHEN t.task_type='alert' THEN 1 END) as alerts,
        COUNT(CASE WHEN t.task_type='task' THEN 1 END) as tasks
        FROM daily_reports r
        LEFT JOIN tasks t ON r.id = t.daily_report_id
        WHERE r.user_id = $user_id
        GROUP BY r.id
        ORDER BY r.report_date DESC";
$res = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html>
<head>
    <title>My History</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">DailyShiftReport</a>
    <div class="navbar-nav ms-auto">
      <a class="nav-link" href="dashboard.php">Dashboard</a>
      <a class="nav-link active" href="reports.php">History</a>
      <a class="nav-link text-danger" href="logout.php">Logout</a>
    </div>
  </div>
</nav>
<div class="container mt-4">
    <h2>Report History</h2>
    <a href="dashboard.php" class="btn btn-primary mb-3">Go to Today</a>
    <table class="table table-bordered bg-white">
        <thead>
            <tr>
                <th>Date</th><th>Shift</th><th>Hours</th><th>Tickets</th><th>WA</th><th>Chats</th><th>Alerts</th><th>Tasks</th><th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = mysqli_fetch_assoc($res)): ?>
            <tr>
                <td><?= $row['report_date'] ?></td>
                <td><?= ucfirst($row['shift']) ?></td>
                <td><?= $row['total_worked_hours'] ?></td>
                <td><?= $row['tickets'] ?></td>
                <td><?= $row['whatsapps'] ?></td>
                <td><?= $row['chats'] ?></td>
                <td><?= $row['alerts'] ?></td>
                <td><?= $row['tasks'] ?></td>
                <td>
                    <a href="dashboard.php?date=<?= $row['report_date'] ?>" class="btn btn-sm btn-info">View</a>
                    <a href="export_tasks.php?date=<?= $row['report_date'] ?>" class="btn btn-sm btn-success">CSV</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>
