<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <span class="navbar-brand">Daily Report - Admin</span>
    <div class="d-flex">
      <span class="navbar-text text-white me-3">
        <?php echo htmlspecialchars($_SESSION['user']['name']); ?> (Admin)
      </span>
      <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <div class="row">
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <h5 class="card-title mb-2">All Tasks</h5>
          <p class="text-muted small">View all employee tasks with shift & date.</p>
          <a href="view_tasks.php" class="btn btn-primary w-100">Open Task View</a>
        </div>
      </div>
    </div>
  </div>
</div>

</body>
</html>
