<?php
session_start();
include "../config/db.php";

if (isset($_SESSION['user'])) {
    if ($_SESSION['user']['role'] == 'admin') {
        header("Location: ../admin/dashboard.php");
    } else {
        header("Location: ../employee/dashboard.php");
    }
    exit;
}

$message = "";

if (isset($_POST['login'])) {
    $email    = mysqli_real_escape_string($conn, $_POST['email']);
    $password = $_POST['password'];

    $q = mysqli_query($conn, "SELECT * FROM users WHERE email='$email'");
    if ($q && mysqli_num_rows($q) == 1) {
        $user = mysqli_fetch_assoc($q);

        if (password_verify($password, $user['password'])) {
            $_SESSION['user'] = $user;

            if ($user['role'] == 'admin') {
                header("Location: ../admin/dashboard.php");
            } else {
                header("Location: ../employee/dashboard.php");
            }
            exit;
        } else {
            $message = "Invalid password.";
        }
    } else {
        $message = "User not found.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Login - Daily Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="min-height:100vh;">

<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <h4 class="mb-3 text-center">Daily Report Login</h4>

          <?php if ($message != ""): ?>
            <div class="alert alert-danger py-2"><?php echo $message; ?></div>
          <?php endif; ?>

          <form method="POST">
            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Password</label>
              <input type="password" name="password" class="form-control" required>
            </div>

            <button type="submit" name="login" class="btn btn-primary w-100">
              Login
            </button>
          </form>

          <div class="mt-3 text-center">
            <a href="register.php">New user? Register</a>
          </div>
        </div>
      </div>
      <p class="text-center text-muted small mt-3 mb-0">© <?php echo date('Y'); ?> Daily Report System</p>
    </div>
  </div>
</div>

</body>
</html>
