<?php
session_start();
include "../config/db.php";

// If user is already logged in, redirect based on role
if (isset($_SESSION['user'])) {
    if ($_SESSION['user']['role'] == 'admin') {
        header("Location: ../admin/dashboard.php");
    } else {
        header("Location: ../employee/dashboard.php");
    }
    exit;
}

$message = "";

if (isset($_POST['register'])) {
    $name     = mysqli_real_escape_string($conn, $_POST['name']);
    $email    = mysqli_real_escape_string($conn, $_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role     = $_POST['role']; // admin / employee
    $team     = isset($_POST['team']) ? $_POST['team'] : 'General';

    // For safety: if role is admin, you can force team to General (optional)
    // if ($role === 'admin') {
    //     $team = 'General';
    // }

    // Check if email already exists
    $check = mysqli_query($conn, "SELECT id FROM users WHERE email='$email'");
    if (!$check) {
        $message = "Database error: " . mysqli_error($conn);
    } elseif (mysqli_num_rows($check) > 0) {
        $message = "Email already exists!";
    } else {
        $query = "INSERT INTO users (name, email, password, role, team)
                  VALUES ('$name', '$email', '$password', '$role', '$team')";
        if (mysqli_query($conn, $query)) {
            $message = "Registration successful! You can now login.";
        } else {
            $message = "Registration failed: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>User Registration - Daily Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="min-height:100vh;">

<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-5">
      <div class="card shadow-sm">
        <div class="card-body">
          <h4 class="mb-3 text-center">Register User</h4>

          <?php if ($message != ""): ?>
            <div class="alert alert-info py-2"><?php echo $message; ?></div>
          <?php endif; ?>

          <form method="POST">
            <div class="mb-3">
              <label class="form-label">Full Name</label>
              <input type="text" name="name" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Password</label>
              <input type="password" name="password" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Role</label>
              <select name="role" class="form-select">
                <option value="employee">Employee</option>
                <option value="admin">Admin</option>
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label">Team (for employees)</label>
              <select name="team" class="form-select">
                <option value="TechOps1">TechOps1</option>
                <option value="TechOps2">TechOps2</option>
                <option value="General">General</option>
              </select>
            </div>

            <button type="submit" name="register" class="btn btn-primary w-100">
              Register
            </button>
          </form>

          <div class="mt-3 text-center">
            <a href="login.php">Already have an account? Login</a>
          </div>
        </div>
      </div>
      <p class="text-center text-muted small mt-3 mb-0">
        © <?php echo date('Y'); ?> Daily Report System
      </p>
    </div>
  </div>
</div>

</body>
</html>
