<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'employee') {
    header("Location: ../auth/login.php");
    exit;
}
include "../config/db.php";

$user_id = $_SESSION['user']['id'];
$today   = date("Y-m-d");

$r = mysqli_query($conn, "SELECT * FROM daily_reports WHERE user_id = $user_id AND report_date = '$today'");
$report = mysqli_fetch_assoc($r);
if (!$report) {
    header("Location: select_shift.php");
    exit;
}

$message = "";

if (isset($_POST['submit'])) {
    $type   = $_POST['task_type']; // ticket/chat/alert/task
    $client = mysqli_real_escape_string($conn, $_POST['client_name']);
    $ticket = mysqli_real_escape_string($conn, $_POST['ticket_id']);
    $desc   = mysqli_real_escape_string($conn, $_POST['description']);
    $time   = mysqli_real_escape_string($conn, $_POST['time_spent']);

    $q = "INSERT INTO tasks (daily_report_id, task_type, client_name, ticket_id, description, time_spent)
          VALUES ({$report['id']}, '$type', '$client', '$ticket', '$desc', '$time')";
    if (mysqli_query($conn, $q)) {
        $message = "Task added successfully.";
    } else {
        $message = "Error: " . mysqli_error($conn);
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Add Task</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <span class="navbar-brand">Daily Report</span>
    <div class="d-flex">
      <a href="dashboard.php" class="btn btn-outline-light btn-sm me-2">Dashboard</a>
      <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <div class="row justify-content-center">
    <div class="col-md-7">
      <div class="card shadow-sm">
        <div class="card-body">
          <h4 class="card-title mb-3">Add Entry (<?php echo ucfirst($report['shift']); ?> shift)</h4>

          <?php if ($message != ""): ?>
            <div class="alert alert-info py-2"><?php echo $message; ?></div>
          <?php endif; ?>

          <form method="POST">
            <div class="mb-3">
              <label class="form-label">Entry Type</label>
              <select name="task_type" class="form-select">
                <option value="ticket">Ticket</option>
                <option value="chat">Chat</option>
                <option value="alert">Alert</option>
                <option value="task">Task</option>
              </select>
              <div class="form-text">
                Ticket → ticket list, Chat → chat count, Alert → alerts section, Task → task list.
              </div>
            </div>

            <div class="mb-3">
              <label class="form-label">Client Name</label>
              <input type="text" name="client_name" class="form-control" placeholder="changeip / Royalcloud / Virtina ..." required>
            </div>

            <div class="mb-3">
              <label class="form-label">Ticket ID (only for tickets)</label>
              <input type="text" name="ticket_id" class="form-control" placeholder="761487">
            </div>

            <div class="mb-3">
              <label class="form-label">Description</label>
              <textarea name="description" class="form-control" rows="3" placeholder="Invoice Increase / website not visible / athena disk usage ..." required></textarea>
            </div>

            <div class="mb-3">
              <label class="form-label">Time Spent (optional)</label>
              <input type="text" name="time_spent" class="form-control" placeholder="e.g. 30 mins">
            </div>

            <button type="submit" name="submit" class="btn btn-success w-100">Save</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

</body>
</html>
